/*
 * Decompiled with CFR 0.152.
 */
package core.states;

import core.GameWindow;
import core.MinionInvaders;
import core.Sprite;
import core.enums.Difficulty;
import core.enums.Mode;
import core.enums.State;
import core.modes.GameMode;
import core.modes.StoryGameMode;
import core.modes.SurvivalGameMode;
import core.modes.TouhouGameMode;
import core.states.StateIf;
import entities.Entity;
import entities.creatures.EnemyCreatureEntity;
import entities.creatures.PlayerCreatureEntity;
import entities.creatures.player.SonaEntity;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Random;
import org.lwjgl.opengl.Display;
import util.Config;
import util.PathTools;
import util.ResourceManager;

public final class GameState
implements StateIf {
    private static final GameState single = new GameState();
    private MinionInvaders game;
    private int width;
    private Mode mode = Mode.STORY;
    private Difficulty difficulty = Difficulty.MEDIUM;
    private int unlockableLevels = 31;
    private ArrayList<Entity> entities = new ArrayList();
    private ArrayList<Entity> removeList = new ArrayList();
    private PlayerCreatureEntity player = null;
    private boolean pauseHasBeenReleased = false;
    private boolean fireHasBeenReleased = false;
    private boolean abilityQHasBeenReleased = false;
    private boolean abilityWHasBeenReleased = false;
    private boolean abilityEHasBeenReleased = false;
    private boolean abilityRHasBeenReleased = false;
    private boolean abilityDHasBeenReleased = false;
    private boolean abilityFHasBeenReleased = false;
    private long lastNoteAnimationTime;
    private int noteX1;
    private int noteX2;
    private int noteX3;
    private int noteY1;
    private int noteY2;
    private int noteY3;
    private int maxEnemyCount = 0;
    private int enemyCount = 0;
    private int deathCount = 0;
    private boolean waitingForKeyPress = true;
    private boolean paused = false;
    private boolean levelUp = false;
    private int level;
    private long startTime = 0L;
    private long levelStartTime = 0L;
    private long pauseStartTime = 0L;
    private long pausedTime = 0L;
    private Sprite win1;
    private Sprite win2;
    private Sprite guiDeaths;
    private Random random = new Random();
    private GameMode gamemode;

    public static GameState get() {
        return single;
    }

    private GameState() {
        this.game = ResourceManager.get().getGame();
        this.width = (int)ResourceManager.get().getDimension().getWidth();
        message.text = "Press Space to start";
        message.x = this.width / 2;
        message.y = 470;
        this.initSprites();
        this.startGame();
    }

    public int getLevel() {
        return this.level;
    }

    public void startGame() {
        this.entities.clear();
        this.removeList.clear();
        this.paused = false;
        this.waitingForKeyPress = true;
        this.levelUp = false;
        message.text = "Press Space to start";
        message.x = this.width / 2;
        message.y = 470;
        this.preparePlayerEntity();
        this.level = 1;
        this.deathCount = 0;
        this.startTime = this.getTime();
        switch (this.mode) {
            case STORY: {
                this.gamemode = new StoryGameMode(this);
                break;
            }
            case SURVIVAL: {
                this.gamemode = new SurvivalGameMode(this);
                break;
            }
            case TOUHOU: {
                this.gamemode = new TouhouGameMode(this);
            }
        }
    }

    public void startLevel() {
        if (this.levelUp) {
            this.levelUp = false;
            ++this.level;
        }
        if (this.level > this.getLevelFromProps() && this.level <= this.unlockableLevels) {
            this.writeLevelIntoProps();
        }
        this.paused = false;
        this.abilityFHasBeenReleased = false;
        this.abilityDHasBeenReleased = false;
        this.abilityRHasBeenReleased = false;
        this.abilityEHasBeenReleased = false;
        this.abilityWHasBeenReleased = false;
        this.abilityQHasBeenReleased = false;
        this.fireHasBeenReleased = false;
        this.pauseHasBeenReleased = false;
        this.maxEnemyCount = 0;
        this.enemyCount = 1;
        this.entities.clear();
        this.removeList.clear();
        this.levelStartTime = this.getTime();
        this.gamemode.startLevel();
        this.preparePlayerEntity();
    }

    private void initSprites() {
        this.win1 = ResourceManager.get().getSprite("particles/win1");
        this.win2 = ResourceManager.get().getSprite("particles/win2");
        this.guiDeaths = ResourceManager.get().getSprite("interface/deaths");
    }

    public void preparePlayerEntity() {
        if (this.player == null) {
            this.player = new SonaEntity(this, this.width / 2 - 15, 510);
        } else {
            this.player.reset();
            this.player.resetPosition(this.width / 2 - 15, 510);
        }
        if (!this.entities.contains(this.player)) {
            this.entities.add(this.player);
        }
    }

    public void removeEntity(Entity entity) {
        this.removeList.add(entity);
    }

    public void playerDead() {
        this.gamemode.playerDead();
    }

    public void addEntity(Entity entity) {
        this.entities.add(entity);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getLevelStartTime() {
        return this.levelStartTime;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public PlayerCreatureEntity getPlayer() {
        return this.player;
    }

    public void focusLost() {
        if (!this.waitingForKeyPress) {
            this.pauseGame();
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void pauseGame() {
        if (!this.waitingForKeyPress) {
            this.paused = true;
            this.waitingForKeyPress = true;
            this.pauseStartTime = this.game.getSystemTime();
        }
    }

    public void unpauseGame() {
        if (this.paused) {
            this.paused = false;
            this.pausedTime += this.game.getSystemTime() - this.pauseStartTime;
        }
    }

    public int getLevelFromProps() {
        PathTools.makeSureDataFilesExist();
        int result = 1;
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(String.valueOf(PathTools.getDataDirectory()) + "level.mi");
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((strLine = br.readLine()) != null) {
                result = Integer.parseInt(strLine);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void writeLevelIntoProps() {
        PathTools.makeSureDataFilesExist();
        try {
            FileWriter fstream = new FileWriter(new File(String.valueOf(PathTools.getDataDirectory()) + "level.mi"));
            BufferedWriter bw = new BufferedWriter(fstream);
            bw.write(String.valueOf(this.level));
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList<Entity> getEntities() {
        return this.entities;
    }

    public void increaseDeathCount() {
        ++this.deathCount;
    }

    public void setWaitingForKeyPress(boolean waitingForKeyPress) {
        this.waitingForKeyPress = waitingForKeyPress;
    }

    protected void levelWin() {
        message.text = "You won level " + this.level + "!\nPress Space to start level " + (this.level + 1);
        message.x = this.width / 2;
        message.y = 245;
        ResourceManager.get().playSound("level_win");
        this.waitingForKeyPress = true;
        this.levelUp = true;
    }

    public long getTime() {
        return this.game.getSystemTime() - this.pausedTime;
    }

    private String getTimeString() {
        if (this.startTime == 0L) {
            return "0:00";
        }
        long time = (long)((double)(this.getTime() - this.startTime) / 1000.0);
        int sec = (int)(time % 60L);
        int min = (int)(time / 60L);
        return String.valueOf(String.valueOf(min)) + (sec < 10 ? ":0" : ":") + String.valueOf(sec);
    }

    public Mode getMode() {
        return this.mode;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public int getModeInt() {
        switch (this.mode) {
            case STORY: {
                return 0;
            }
            case SURVIVAL: {
                return 1;
            }
            case TOUHOU: {
                return 2;
            }
        }
        return 0;
    }

    public int getDifficultyInt() {
        switch (this.difficulty) {
            case EASY: {
                return 0;
            }
            case MEDIUM: {
                return 1;
            }
            case HARD: {
                return 2;
            }
            case LEGENDARY: {
                return 3;
            }
        }
        return 1;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public int getEnemyCount() {
        return this.enemyCount;
    }

    public int getMaxEnemyCount() {
        return this.maxEnemyCount;
    }

    public boolean isWaitingForKeyPress() {
        return this.waitingForKeyPress;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean levelUpPending() {
        return this.levelUp;
    }

    @Override
    public void render(long delta) {
        Entity entity;
        int i;
        GameWindow window = ResourceManager.get().getGameWindow();
        int width = (int)ResourceManager.get().getDimension().getWidth();
        this.gamemode.render(delta);
        window.drawText(GameWindow.FONT_MAIN_DIFFICULTY[this.getDifficultyInt()], width - 5, 573.0f, "Level " + this.level, 3);
        this.guiDeaths.draw(width - this.guiDeaths.getWidth() - 40, 0);
        window.drawText(GameWindow.FONT_MAIN_DIFFICULTY[this.getDifficultyInt()], width - 5, 0.0f, String.valueOf(this.deathCount), 3);
        window.drawText(GameWindow.FONT_MAIN_DIFFICULTY[this.getDifficultyInt()], 710.0f, 0.0f, this.getTimeString(), 3);
        if (!(this.paused || this.mode == Mode.STORY && this.level <= 1)) {
            this.player.drawIcons();
        }
        if (this.levelUp) {
            if (this.lastNoteAnimationTime == 0L || this.lastNoteAnimationTime + 100L < this.getTime()) {
                this.lastNoteAnimationTime = this.getTime();
                this.noteX1 = this.random.nextInt(10);
                this.noteX2 = this.random.nextInt(10);
                this.noteX3 = this.random.nextInt(10);
                this.noteY1 = this.random.nextInt(10);
                this.noteY2 = this.random.nextInt(10);
                this.noteY3 = this.random.nextInt(10);
            }
            this.win1.draw(this.player.getX() + this.player.getW() / 2 - 0 - 30 - this.noteX1, this.player.getY() - 48 - this.noteY1);
            this.win1.draw(this.player.getX() + this.player.getW() / 2 - 8 - 50 - this.noteX2, this.player.getY() - 0 - this.noteY2);
            this.win2.draw(this.player.getX() + this.player.getW() / 2 - 8 + 50 + this.noteX3, this.player.getY() - 16 - this.noteY3);
        }
        if (!this.waitingForKeyPress) {
            if (this.enemyCount == 0) {
                this.levelWin();
            }
            this.enemyCount = 0;
            i = 0;
            while (i < this.entities.size()) {
                entity = this.entities.get(i);
                if (entity instanceof EnemyCreatureEntity) {
                    ++this.enemyCount;
                }
                entity.move(delta);
                entity.doLogic();
                ++i;
            }
            if (this.maxEnemyCount == 0) {
                this.maxEnemyCount = this.enemyCount;
            }
            int p = 0;
            while (p < this.entities.size()) {
                int s = p + 1;
                while (s < this.entities.size()) {
                    Entity entity2;
                    Entity entity1 = this.entities.get(p);
                    if (entity1.collidesWith(entity2 = this.entities.get(s))) {
                        entity1.collidedWith(entity2);
                        entity2.collidedWith(entity1);
                    }
                    ++s;
                }
                ++p;
            }
        }
        if (this.paused) {
            this.pausedTime += this.game.getSystemTime() - this.pauseStartTime;
            this.pauseStartTime = this.game.getSystemTime();
        }
        if (Display.isActive() || Display.isVisible() || Display.isDirty()) {
            i = 0;
            while (i < this.entities.size()) {
                entity = this.entities.get(i);
                if (!(this.waitingForKeyPress && this.levelUp && !(entity instanceof SonaEntity) || this.paused)) {
                    entity.draw();
                }
                ++i;
            }
        }
        this.entities.removeAll(this.removeList);
        this.removeList.clear();
        if (this.waitingForKeyPress) {
            if (this.paused) {
                message.text = "Paused\nPress Space to continue or X to get to the main menu";
                message.x = width / 2;
                message.y = 0;
                this.player.drawPauseMenuInfo();
            }
            if (message.text.equals("Press Space to start")) {
                window.drawText(GameWindow.FONT_TITLE, width / 2, 20.0f, "M i n i o n  I n v a d e r s", 2);
                window.drawText(GameWindow.FONT_SMALL, width - 10, 535.0f, "A game by Daniel Figge", 3);
                this.gamemode.startScreen();
            }
            this.gamemode.drawMessage();
            this.game.sleep(25L);
        }
        boolean leftPressed = window.isKeyPressed(203);
        boolean rightPressed = window.isKeyPressed(205);
        boolean firePressed = window.isKeyPressed(57);
        boolean pausePressed = window.isKeyPressed(1);
        boolean XPressed = window.isKeyPressed(45);
        boolean abilityQPressed = window.isKeyPressed(16);
        boolean abilityWPressed = window.isKeyPressed(17);
        boolean abilityEPressed = window.isKeyPressed(18);
        boolean abilityRPressed = window.isKeyPressed(19);
        boolean abilityDPressed = window.isKeyPressed(32);
        boolean abilityFPressed = window.isKeyPressed(33);
        if (XPressed && this.paused) {
            this.game.setState(State.MAIN_MENU);
        }
        if (!this.waitingForKeyPress) {
            if (pausePressed) {
                if (this.pauseHasBeenReleased) {
                    this.pauseHasBeenReleased = false;
                    this.pauseGame();
                }
            } else {
                this.pauseHasBeenReleased = true;
            }
            if (leftPressed && !rightPressed) {
                this.player.setDx(-this.player.getMoveSpeed());
            } else if (rightPressed && !leftPressed) {
                this.player.setDx(this.player.getMoveSpeed());
            } else {
                this.player.setDx(0.0);
            }
            if (firePressed) {
                this.player.useShot();
            }
            if (this.mode != Mode.STORY || this.level > 1) {
                if (abilityQPressed) {
                    if (this.abilityQHasBeenReleased) {
                        this.abilityQHasBeenReleased = false;
                        this.player.useAbilityQ();
                    }
                } else {
                    this.abilityQHasBeenReleased = true;
                }
                if (abilityWPressed) {
                    if (this.abilityWHasBeenReleased) {
                        this.abilityWHasBeenReleased = false;
                        this.player.useAbilityW();
                    }
                } else {
                    this.abilityWHasBeenReleased = true;
                }
                if (abilityEPressed) {
                    if (this.abilityEHasBeenReleased) {
                        this.abilityEHasBeenReleased = false;
                        this.player.useAbilityE();
                    }
                } else {
                    this.abilityEHasBeenReleased = true;
                }
                if (abilityRPressed) {
                    if (this.abilityRHasBeenReleased) {
                        this.abilityRHasBeenReleased = false;
                        this.player.useAbilityR();
                    }
                } else {
                    this.abilityRHasBeenReleased = true;
                }
                if (abilityDPressed) {
                    if (this.abilityDHasBeenReleased) {
                        this.abilityDHasBeenReleased = false;
                        this.player.useAbilityD();
                    }
                } else {
                    this.abilityDHasBeenReleased = true;
                }
                if (abilityFPressed) {
                    if (this.abilityFHasBeenReleased) {
                        this.abilityFHasBeenReleased = false;
                        this.player.useAbilityF();
                    }
                } else {
                    this.abilityFHasBeenReleased = true;
                }
            }
        } else if (firePressed) {
            if (this.fireHasBeenReleased) {
                this.waitingForKeyPress = false;
                this.fireHasBeenReleased = false;
                if (this.paused) {
                    this.unpauseGame();
                } else if (this.deathCount == 0) {
                    this.startLevel();
                } else {
                    this.gamemode.afterGameLost();
                }
            }
        } else {
            this.fireHasBeenReleased = true;
        }
        if (!Display.isActive()) {
            this.focusLost();
        }
    }

    public boolean isAttackDelayOver() {
        return GameState.get().getLevelStartTime() + (long)Config.get(Config.enemyAttackDelay) < GameState.get().getTime();
    }

    public void refreshEnemyCount() {
        this.enemyCount = 0;
        int i = 0;
        while (i < this.entities.size()) {
            Entity entity = this.entities.get(i);
            if (entity instanceof EnemyCreatureEntity) {
                ++this.enemyCount;
            }
            ++i;
        }
    }

    public static final class message {
        public static String text;
        public static int x;
        public static int y;
    }
}

